/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.inventory.capability.ISlotCallback;
import net.dries007.tfc.objects.inventory.capability.ItemStackHandlerCallback;
import net.dries007.tfc.objects.te.TEBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public abstract class TEInventory
extends TEBase
implements ISlotCallback {
    protected final ItemStackHandler inventory;

    protected TEInventory(int inventorySize) {
        this.inventory = new ItemStackHandlerCallback(this, inventorySize);
    }

    protected TEInventory(ItemStackHandler inventory) {
        this.inventory = inventory;
    }

    protected TEInventory(BiFunction<ISlotCallback, Integer, ItemStackHandler> builder, int inventorySize) {
        this.inventory = builder.apply(this, inventorySize);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(i));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

